'Version 2.0 May 2015 Taken over WIA repeater file creation
'Version 1.5 Dec 2013 Created LongLat Merge Version and improved handling of Notes
'Version 1.4 Sept 2013 Callsign filtering bug. 1 call area filter now works
'Version 1.3 Feb 2013 Script now ignores blank lines
'Version 1.2 July 2012 Added the /f filter to limit output to a list of states
'Version 1.1 June 2012 Fixed mismatched header columns and repeater columns, Added other sections
'Version 1.0 March 2012 - Original
'Copyright (c) Steve Ireland 2012
'WiaRep2Chirp.vbs and all other variants that start with WiaRep2 were originaly written by Steve Ireland VK2MD (vk2md@wia.org.au)
'This application can be freely distributed, modified and used by anybody for both private and commercial purposes.

'If you make changes to the software please add the statements above to your source code to achnowledge Steve Ireland VK2MD as the original author and to freely 
'distribute your software.
'Please Please Please do not use the file name prefix WiaRep2 or WiaRepTo as I use this prefix on software that I maintain.
'In essance the naming convention is the only intellectual property that I assert purely for maintenance purposes.
'Have fun. Steve March 2012


'This script will read the Repeater Directory Master CSV file and create a chirp csv file


'To run this script 
'   cscript WiaRep2Chirp.vbs .\zip\vkrep2LongLat.csv .\zip\Output\chirp.csv
'   use the /f option to filter on states. eg /f:vk1,vk2,vk3 will only output repeaters from the listed states
'   use the /m option to select mNemonics rather than callsigns

'//Nologo  //X .\Scripts\WiaRep2Chirp.vbs /m  ".\Repeater Directory Master.csv" ".\production\chirp.csv"


 
Option Explicit
Dim args
Const ForReading = 1, ForWriting = 2, ForAppending = 8


Main

Sub Main()
    If ParseArgs() < 2 Then
        wscript.echo "Usage: cscript WiaRep2Chirp.vbs ""Repeater Directory.csv"" chirp.csv"
        wscript.echo "       Use option /f to filter states"
        wscript.echo "       Use option /m to use mNemonics"
        Exit Sub
    End If

    'Go load the WIA repeater file using the passed in file name in arg0
    Dim bands
    wscript.echo "Loading WIA File into an Array of bands with repeater dictionaries"
    bands = LoadWia(args("arg0"))

    'The WIA repeater csv will evolve over time so just test how big it is wrt the size it was when the script was developed
    If Not (UBound(bands) = 34 or UBound(bands) = 42) Then
        wscript.echo "Warning. The number of band sections in the WIA script has changed."
        wscript.echo "The script will try to continue but may miss out the extra data or crash."
        wscript.echo
    End If

    wscript.echo "Creating Chirp File " & args("arg1")
    SaveChirp args("arg1"), bands

End Sub

'parses the arguments passed in and places them in a global dictionary for easy access
Function ParseArgs
    Dim namelessCount
    namelessCount = 0
    set args = CreateObject("Scripting.Dictionary") 'args are global

    Dim i
    For i=0 to WScript.Arguments.Count - 1
        Dim arg
        arg = WScript.Arguments.Item(i)
        If Left(arg,1) = "/" Or Left(arg,1) = "-" Then
            arg = Replace(arg,"/","")
            arg = Trim(arg)
            Dim parts
            parts = Split(arg,":")
            If UBound(parts) = 0 Then
                args.Add parts(0),""
            Else
                args.Add parts(0),parts(1)
            End If
        Else
            args.Add "arg" & CStr(namelessCount),arg
            namelessCount = namelessCount + 1
        End If
    Next

    ParseArgs = WScript.Arguments.Count
End Function

'Load the WIA CSV file into memory
'Returns a list of bands, that contains a list of repeaters. Each repeater entry is a dictionary
' eg bands(3)(32)("Call") will go to section 3, repeater number 32 and retrieve the Call entry as a string. Cool!
Function LoadWia(sourceCSV)
    Dim bands()
    LoadWia = bands

    Dim fso 
    set fso = CreateObject("Scripting.FileSystemObject")

    Dim file
    Set file = fso.OpenTextFile(sourceCSV, ForReading)
    If file.AtEndOfStream Then
        Exit Function
    End If

    'read in the header and get rid of all those extra quotes
    Dim header
    Dim i
    header = Split(Trim(Replace(file.ReadLine,"""","")),",") 
    For i=0 To UBound(header)
       header(i) = Trim(header(i)) 'Another Trim as one of the headers has an extra space at the end :-)
    Next

    'test that it is a WIA repeater file
    If header(0) <> "Output" And header(1) <> "Input" And header(2) <> "Call" Then
        wscript.echo sourceCSV & " is not a WIA repeater CSV file"
        Exit Function
    End If

    'read first line as it is a band seperator with commas everywhere and gives band information
    Dim bandSeparator
    bandSeparator = Split(Trim(Replace(file.ReadLine,"""","")),",")

    'load up every band
    Dim numBands
    numBands=0
    Do While file.AtEndOfStream <> True
        Dim band
        band = LoadWiaBand(file, header, bandSeparator)
        ReDim Preserve bands(numBands) 'expand the list
        bands(numBands) = band
        numBands = numBands + 1
    Loop
    file.Close

    LoadWia = bands 'return the whole structure
End Function


Function LoadWiaBand(file, header, bandSeparator)
    Dim repeater
    Dim repeaterDict
    Dim numRepeaters
    Dim band()

    numRepeaters = 0
    Do While file.AtEndOfStream <> True
        repeater = Split(Trim(Replace(file.ReadLine,"""","")),",") 'read in a repeater line from the file and split on a ,
        If UBound(repeater) > 2 Then 'skip illegal lines

            Dim i
            For i=0 To UBound(repeater) 'Trim up every field
               repeater(i) = Trim(repeater(i))
            Next
            'each band is seperated by and empty row
            If repeater(0) = "" And repeater(1) ="" And repeater(2) = "" Then
                bandSeparator = repeater
                LoadWiaBand = band
                Exit Function
            End If

            'create a repeater dictionary for each row keyed on the header
            set repeaterDict = CreateObject("Scripting.Dictionary")
            For i=0 to UBound(header)
                If i <= UBound(repeater) Then
                    If i < UBound(header) Then
                        repeaterDict.Add header(i), repeater(i) 
                    Else 'The note field can have extra , so we need to recombine them
                        Dim noteLine
                        noteLine = ""
                        Dim j
                        For j=i to UBound(repeater)
                            noteLine = noteLine & repeater(j) & ","
                        Next
                        noteLine = Left(noteLine,Len(noteLine)-1)
                        repeaterDict.Add header(i), noteLine 
                    End If
                Else
                    printMismatch(header)
                    printMismatch(repeater)
                    wscript.echo "Repeater has incorrect number of columms compared to header and has been skipped"
                    wscript.echo
                End If
            Next
            
            repeaterDict.Add "Tag",bandSeparator(14)

            'Into the band list goes the repeater dictionary
            ReDim Preserve band(numRepeaters)
            set band(numRepeaters) = RepeaterDict
            numRepeaters = numRepeaters + 1
        End If
    Loop
    LoadWiaBand = band
End Function

Sub printMismatch(entry)
    Dim Line
    Line = ""
    Dim i
    For i=0 to UBound(entry)
        Line = Line & entry(i) & ", "
    Next
    wscript.echo Line
End Sub



Sub SaveChirp(filename, bands)
    Dim loc
    loc = 0

    Dim fso 
    set fso = CreateObject("Scripting.FileSystemObject")
    Dim file

    If fso.FileExists(filename) Then
        fso.DeleteFile filename, True 'Force delete the file if it exists
    End If

    Set file = fso.CreateTextFile(filename)

    wscript.echo "Created File " & filename

    'Write the header and save
    WriteChirpHeader file

    loc = SaveChirpVHF(file, loc, bands)
    loc = SaveChirpUHF(file, loc, bands)
    loc = SaveChirp23cm(file, loc, bands)
    loc = SaveChirpDStar(file, loc, bands)

    file.Close()
    wscript.echo
    wscript.echo CStr(loc+1) & " repeaters processed"

End Sub


Function SaveChirpVHF(file, loc, bands)

    wscript.echo
    wscript.echo "Generating VHF Entries"

    const bandStart = 7 'vhfbands are 7 to 13 when this was written. It may change!
    const bandEnd = 13
    const callSuffix = "2"

    SaveChirpVHF = SaveChirpFM(file, loc, bands, bandStart, bandEnd, callSuffix)

End Function

Function SaveChirpUHF(file, loc, bands)
    wscript.echo
    wscript.echo "Generating UHF Entries"

    const bandStart = 14 'uhfbands are 14 to 20 when this was written. It may change!
    const bandEnd = 20
    const callSuffix = "7"

    SaveChirpUHF = SaveChirpFM(file, loc, bands, bandStart, bandEnd, callSuffix)

End Function

Function SaveChirp23cm(file, loc, bands)
    wscript.echo
    wscript.echo "Generating 23 CM Entries"

    const bandStart = 21 '23cm bands are 21 to 24 when this was written. It may change!
    const bandEnd = 25
    const callSuffix = "U"

    SaveChirp23cm = SaveChirpFM(file, loc, bands, bandStart, bandEnd, callSuffix)

End Function


Function SaveChirpDStar(file, loc, bands)
    wscript.echo
    wscript.echo "Generating DStar Entries"

    const bandStart = 26 'dstarbands are 25 to 30 when this was written. It may change!
    const bandEnd = 32

    SaveChirpDStar = SaveChirpDV(file, loc, bands, bandStart, bandEnd)

End Function


Function SaveChirpFM(file, loc, bands, loopStart, loopEnd, callSuffix)

    'uninitialised locals
    Dim Line
    Dim i
    For i=loopStart to loopEnd 
        Dim repeater
        For Each repeater in bands(i)

            If RepeaterCallsignInFilter(repeater) = True Then

                'test to make sure that input and output frequencies are within the radios range, otherwise skip
                'There is a 10m repeater with a 2m output freq
                If (    ((CDbl(repeater("Output")) >= 144.0 And CDbl(repeater("Output")) < 148.0) Or (CDbl(repeater("Output")) >= 420.0 And CDbl(repeater("Output")) < 450.0) Or (CDbl(repeater("Output")) >= 1240.0 And CDbl(repeater("Output")) < 1300.0)) And _
                        ((CDbl(repeater("Input")) >= 144.0 And CDbl(repeater("Input")) < 148.0) Or (CDbl(repeater("Input")) >= 420.0 And CDbl(repeater("Input")) < 450.0) Or (CDbl(repeater("Input")) >= 1240.0 And CDbl(repeater("Input")) < 1300.0)) _
                   ) Then

                    'write each field into a string
                    Line = WriteChirpLocation(CStr(loc))
                    Line = Line & WriteChirpName(CallsignOrmNemonic(repeater),callSuffix)
                    Line = Line & WriteChirpFrequency(repeater("Output"))
                    Line = Line & WriteChirpDup(repeater("Output"), repeater("Input"))
                    Line = Line & WriteChirpOffset(repeater("Output"), repeater("Input"))
                    Line = Line & WriteChirpTone(repeater("Tone"))
                    Line = Line & WriteChirpRepeaterTone(repeater("Tone"))
                    Line = Line & WriteChirpcToneFreq()
                    Line = Line & WriteChirpDTCSCode()
                    Line = Line & WriteChirpDTCSPolarity()
                    Line = Line & WriteChirpMode("FM")
                    Line = Line & WriteChirpTStep("5.0")
                    Line = Line & WriteChirpSkip()
                    Line = Line & WriteChirpComment()
                    Line = Line & WriteChirpYourCallSign("")
                    Line = Line & WriteChirpRPT1CallSign("")
                    Line = Line & WriteChirpRPT2CallSign("")
                    'Write to the file
                    file.WriteLine(Line)
                    Wscript.StdOut.Write "."
                    loc = loc + 1
                End If
            End If
        Next
    Next

    SaveChirpFM = loc

End Function

Function SaveChirpDV(file, loc, bands, loopStart, loopEnd)
 
    'uninitialised locals
    Dim Line
    Dim i
    For i=loopStart to loopEnd 
        Dim repeater
        For Each repeater in bands(i)

            If RepeaterCallsignInFilter(repeater) = True Then

                'test to make sure that input and output frequencies are within the radios range, otherwise skip
                'dstar section contains 23cm frequencies
                If (    ((CDbl(repeater("Output")) >= 144.0 And CDbl(repeater("Output")) < 148.0) Or (CDbl(repeater("Output")) >= 420.0 And CDbl(repeater("Output")) < 450.0) Or (CDbl(repeater("Output")) >= 1240.0 And CDbl(repeater("Output")) < 1300.0)) And _
                        ((CDbl(repeater("Input")) >= 144.0 And CDbl(repeater("Input")) < 148.0) Or (CDbl(repeater("Input")) >= 420.0 And CDbl(repeater("Input")) < 450.0) Or (CDbl(repeater("Input")) >= 1240.0 And CDbl(repeater("Input")) < 1300.0)) _
                   ) Then

                    'write each field into a string
                    Line = WriteChirpLocation(CStr(loc))
                    Line = Line & WriteChirpName(repeater("Call"),"")
                    Line = Line & WriteChirpFrequency(repeater("Output"))
                    Line = Line & WriteChirpDup(repeater("Output"), repeater("Input"))
                    Line = Line & WriteChirpOffset(repeater("Output"), repeater("Input"))
                    Line = Line & WriteChirpTone(repeater("Tone"))
                    Line = Line & WriteChirpRepeaterTone(repeater("Tone"))
                    Line = Line & WriteChirpcToneFreq()
                    Line = Line & WriteChirpDTCSCode()
                    Line = Line & WriteChirpDTCSPolarity()
                    Line = Line & WriteChirpMode("DV")
                    Line = Line & WriteChirpTStep("5.0")
                    Line = Line & WriteChirpSkip()
                    Line = Line & WriteChirpComment()
                    Line = Line & WriteChirpYourCallSign("CQCQCQ")
                    Line = Line & WriteChirpRPT1CallSign(expandCallSign(repeater("Call"),"")) 'different to FM
                    Line = Line & WriteChirpRPT2CallSign(expandCallSign(repeater("Call"),"G")) 'Force a G on the end as RPT2

                    'Write to the file
                    file.WriteLine(Line)
                    Wscript.StdOut.Write "."
                    loc = loc + 1
                End if
            End If
        Next
    Next
    SaveChirpDV = loc
End Function

Function RepeaterCallsignInFilter(repeater)
     If Not args.Exists("f") Then 
         RepeaterCallsignInFilter = True
         Exit Function
     End If

    Dim parts
    parts = Split(args("f"),",")
    If UBound(parts) = -1 Then
         RepeaterCallsignInFilter = True
         Exit Function
    End If

    Dim i
    For i=0 to UBound(parts)
        If InStr(UCase(repeater("Call")),UCase(parts(i))) <> 0 Then
            RepeaterCallsignInFilter = True
            Exit Function
        End If
    Next

    RepeaterCallsignInFilter = False

End Function

Function CallsignOrmNemonic(repeater)
    CallsignOrmNemonic = repeater("Call")
    If Not args.Exists("m") Then
        Exit Function
    End If

    If Not repeater.Exists("mNemonic") Then 'may be a raw WIA file with no mNemonic Column
        Exit Function
    End If

    if repeater("mNemonic") = "-" Or repeater("mNemonic") = "" Then
        Exit Function
    End If
    CallsignOrmNemonic = repeater("mNemonic")
End Function


'Chirp Support files
'They create the Chirp fields by converting the WIA fields

Sub WriteChirpHeader(file)
   file.WriteLine("Location,Name,Frequency,Duplex,Offset,Tone,rToneFreq,cToneFreq,DtcsCode,DtcsPolarity,Mode,TStep,Skip,Comment,URCALL,RPT1CALL,RPT2CALL")
End Sub

Function WriteChirpLocation(loc)
    WriteChirpLocation = CStr(loc) & ","
End Function

'You can space out the call sign to 8 chars if you wish and add a character in the 8th position (note overwrites)
Function WriteChirpName(callsign, suffix)
    If suffix = "" Then 'do nothing case
        WriteChirpName = callsign & ","
        Exit Function
    End if
    WriteChirpName = expandCallsign(callsign, suffix) & ","
End Function

'Expand out to at least 8 characters filing with spaces
'Position 8 can be overwritten
Function expandCallSign(callsign,suffix)
    dim expanded
    expanded = callsign & space(8)
    if suffix = "" Then
        expanded = Left(expanded , 8) 'suffix is empty so use the space
    Else
        expanded = Left(expanded , 7) 'hmm suffix MUST be only 1 char
    End If
    expandCallSign = expanded & suffix
End Function

Function WriteChirpFrequency(freq)
    WriteChirpFrequency = FormatNumber(CSng(freq),6,vbTrue,vbFalse,vbFalse) & ","
End Function

Function WriteChirpDup(freqOutput, freqInput)
    If CSng(freqOutput) > CSng(freqInput) Then
        WriteChirpDup = "-,"
    ElseIf CSng(freqOutput) < CSng(freqInput) Then
        WriteChirpDup = "+,"
    Else
        WriteChirpDup = ","
    End If
End Function

Function WriteChirpOffset(freqOutput, freqInput)
    'This converts the offset producing no rounding issues
    'Convert string to a floating point Single (CSng), change MHz to Hz but multipling by 1000000.0, convert to a big integer (CLng)
    'Subtract the 2 big integers and change back to a floating point Single (CSng)
    'convert back to MHz by dividing by 1000000.0
    'strip of negative offsets these are handled by the duplex field
    'Convert it all back to a string
    'Voila
    WriteChirpOffset = FormatNumber(Abs(CDbl(CLng(CDbl(freqOutput)*10000.0) - CLng(CDbl(freqInput)*10000.0))/10000.0),6,vbTrue,vbFalse,vbFalse) & ","
End Function

Function WriteChirpTone(tone)
    If tone = "-" Then
        WriteChirpTone = ","
    Else
        WriteChirpTone = "Tone,"
    End If
End Function

Function WriteChirpRepeaterTone(tone)
    If tone = "-" Or tone = " " Or tone ="" Then 'tone is a little variable in the wia csv file
        WriteChirpRepeaterTone = "88.5,"
    Else
        WriteChirpRepeaterTone = FormatNumber(CSng(tone),1,vbTrue,vbFalse,vbFalse) & "," 'Looks like Tone must always have 1 character after the decimal point
    End If
End Function

Function WriteChirpcToneFreq()
    WriteChirpcToneFreq = "88.5,"
End Function

Function WriteChirpDTCSCode()
    WriteChirpDTCSCode = "023,"
End Function

Function WriteChirpDTCSPolarity()
    WriteChirpDTCSPolarity = "NN,"
End Function

Function WriteChirpMode(mode)
    WriteChirpMode = mode & ","
End Function

Function WriteChirpTStep(freqStep)
    WriteChirpTStep = freqStep & ","
End Function

Function WriteChirpSkip()
    WriteChirpSkip = ","
End Function

Function WriteChirpComment()
    WriteChirpComment = ","
End Function

Function WriteChirpYourCallSign(callsign)
    WriteChirpYourCallSign = callsign & ","
End Function

Function WriteChirpRPT1CallSign(callsign)
    WriteChirpRPT1CallSign = callsign &","
End Function

Function WriteChirpRPT2CallSign(callsign)
    WriteChirpRPT2CallSign = callsign 'Last field aways so no comma
End Function

